/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.model.block;

import DE.siemens.ad.logo.model.Analog;
import DE.siemens.ad.logo.model.AnalogBlock;
import DE.siemens.ad.logo.model.AnalogInBlockConnector;
import DE.siemens.ad.logo.model.BinaryInBlockConnector;
import DE.siemens.ad.logo.model.BinaryOutBlockConnector;
import DE.siemens.ad.logo.model.Block;
import DE.siemens.ad.logo.model.InBlockConnector;
import DE.siemens.ad.logo.model.OutBlockConnector;
import DE.siemens.ad.logo.model.PWMParameter;
import DE.siemens.ad.logo.model.ParameterInBlockConnector;
import DE.siemens.ad.logo.model.ParameterSetListener;
import DE.siemens.ad.logo.model.SpecialBlock;
import DE.siemens.ad.logo.model.WiringDiagram;
import java.util.List;

public class PWMBlock
extends SpecialBlock
implements AnalogBlock {
    private static final long serialVersionUID = 5241378397873354121L;
    private int serializedDataVersion = 1;

    public PWMBlock() {
    }

    public PWMBlock(WiringDiagram wiringDiagram) {
        super(wiringDiagram);
    }

    protected void initInConnectors() {
        this.fInConnectors = new InBlockConnector[3];
        this.fInConnectors[0] = new BinaryInBlockConnector(this, false, "En");
        this.fInConnectors[1] = new AnalogInBlockConnector(this, 0.0, "Ax");
        String name = "DE.siemens.ad.logo.model.PWMParameter";
        this.fInConnectors[2] = new ParameterInBlockConnector((Block)this, name, "Par");
    }

    protected void initOutConnectors() {
        this.fOutConnectors = new OutBlockConnector[1];
        this.fOutConnectors[0] = new BinaryOutBlockConnector(this);
    }

    protected boolean calculateBinaryValue() {
        boolean enable = ((BinaryInBlockConnector)this.fInConnectors[0]).calculateBinaryValue();
        double ax = ((AnalogInBlockConnector)this.fInConnectors[1]).calculateAnalogValue();
        return ((PWMParameter)this.getParameter()).getValue(enable, ax);
    }

    public void addMeasurementBoundsChangedListener(ParameterSetListener listener) {
        this.getParameter().addParameterSetListener(listener);
    }

    public void removeMeasurementBoundsChangedListener(ParameterSetListener listener) {
        this.getParameter().removeAllParameterSetListeners();
    }

    public void collectSensors(List sensorContainer) {
        Analog analogParameter = (Analog)this.getParameter();
        sensorContainer.add(analogParameter.getMeasurement().getSensor());
    }
}

